; magAccess.jss
; MAGic tracking functions for MSAccess.jss
include "hjconst.jsh"
include "hjglobal.jsh"
Include "magCodes.jsh"
Include "magic.jsh"


Void Function TrackEditWindow (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed, int TheTypeCode, string cwClass, handle appWindow, int nTargetItem)
Var Int nCount, Int bSuccess, Int nL, Int nR, Int nT, Int nB, Int nMaxWidth, Int nLevel
Let nCount = 0
Let nLevel = MagGetOption (MID_LEVEL)
Let bSuccess = FALSE
Let nMaxWidth = ScreenGetWidth () / nLevel
;  Run TrackGeneral in a window with a window class of OKttbx if the text is highlighted
If (GetWindowClass (GetCurrentWindow ()) == mWN_Access) then
  If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
    TrackGeneral (nX, nY, nOldX, nOldY, nUnit, nDir, nTimeElapsed, TheTypeCode, cwClass, AppWindow)
  Else
  EndIf
EndIf
; Obtain the rectangle around the largest object available, if nUnit = IT_WORD or larger, start with IT_WORD
; Otherwise start with IT_CHAR
Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_PRIOR_WORD | IT_WORD)
If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_PRIOR_WORD | IT_WORD) EndIf
If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_PRIOR_WORD | IT_CHAR) EndIf
If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_PRIOR_WORD | IT_CARET)  EndIf
If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_WORD) EndIf
If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHAR) EndIf
If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CARET) EndIf
If (nT <= 10) then Let nT = 0 Else Let nT = nT - 10 EndIf
If (nL <= 10) then Let nL = 0 Else Let nL = nL - 10 EndIf
; End of obtaining the rectangle
;If (GetAppFileName () == NotePadApp) then
  Let nR = nR + ((nR - nL)/3)
;EndIf
If (bSuccess) then
	If ((nR - nL) > nMaxWidth) then Let nR = nX + 15
		If ((nR - nL) > nMaxWidth) then Let nL = nR - nMaxWidth EndIf
		If (nTargetItem == 0) then MagSetFocusToRect (nL, nR + 5, nT, nB + 5, MTO_CARET)
		Else MagFocusRight (nX, nY, nL, nR + 5, nT, nB + 5, MTO_CARET) EndIf
		Return 1
	Else
		If (nTargetItem == 0) then MagSetFocusToRect (nL, nR + 5, nT, nB + 5, MTO_CARET)
		Else MagFocusRight (nX, nY, nL, nR + 5, nT, nB + 5, MTO_CARET) EndIf
	EndIf
	Return 1
Else
	Return bSuccess
EndIf
EndFunction